/*
 * Decompiled with CFR 0.152.
 */
package itx.erp.base.controller;

import com.fasterxml.jackson.core.exc.StreamWriteException;
import com.fasterxml.jackson.databind.DatabindException;
import itx.core.web.BaseController;
import itx.core.web.WebRequest;
import itx.erp.ErpObjectContainer;
import itx.erp.base.service.UserService;
import itx.erp.helper.ErpConfig;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.sql.SQLException;
import java.util.HashMap;
import jtbcore.exception.AuthorizationException;
import jtbcore.license.LicenseHandler;
import jtbcore.util.CacheUtil;
import jtbcore.util.StringUtil;

public class LicenseController
extends BaseController {
    protected ErpConfig appConfig;
    protected UserService userService;

    public ErpConfig getAppConfig() {
        return this.appConfig;
    }

    public void setAppConfig(ErpConfig appConfig) {
        this.appConfig = appConfig;
    }

    public UserService getUserService() {
        return this.userService;
    }

    public void setUserService(UserService userService) {
        this.userService = userService;
    }

    @Override
    public void handleRequest(WebRequest webRequest) throws Exception {
        this.executeAction(webRequest);
    }

    public void indexAction(WebRequest req) throws IOException {
        LicenseHandler lh = new LicenseHandler(this.userService.getConnection());
        req.getResponse().setContentType("application/javascript");
        PrintWriter pw = new PrintWriter((OutputStream)req.getResponse().getOutputStream());
        if (!lh.allowUsage(this.appConfig)) {
            String appName = ErpObjectContainer.getInstance().getProperty("publicAppName");
            Object licenseMessage = appName + " reached its end of free usage. Please see itxplain.nl for more information";
            if (lh.hasUserMessage()) {
                licenseMessage = lh.getUserMessage();
            }
            pw.println("window.addEventListener('EzTemplate.updated', function() {\n\t$('.toolbox a').each(function(index, node) {\n\t\tif ( $(node).closest('.page-no-license-check').length > 0 ) return;\n\t\tif ($(node).hasClass('fa-chevron-circle-left')) return;\n\t\tif ($(node).hasClass('fa-times-circle')) return;\n\n\t\t$(node).remove();\n\t});\n});\n");
            pw.println("showAlert('License', '" + StringUtil.escapeJson((String)licenseMessage) + "');");
        } else if (lh.hasUserMessage()) {
            pw.println("showAlert('License', '" + StringUtil.escapeJson(lh.getUserMessage()) + "');");
        }
        pw.flush();
        pw.close();
    }

    public void saveSettingsAction(WebRequest req) throws StreamWriteException, DatabindException, IOException, SQLException, AuthorizationException {
        if (!this.userService.isAdmin(req.getUserId())) {
            throw new AuthorizationException("Only admin allowed");
        }
        CacheUtil.removeCache("licenseResponse");
        String lc = req.getParameter("appLicenseCode");
        if (lc == null) {
            lc = "";
        }
        lc = lc.trim();
        this.appConfig.setLicenseCode(req.getParameter("appLicenseCode"));
        LicenseHandler lh = new LicenseHandler(this.userService.getConnection());
        Boolean validLicense = lh.checkLicense(this.appConfig, lc);
        HashMap<String, Boolean> result = new HashMap<String, Boolean>();
        result.put("success", true);
        result.put("validLicense", validLicense);
        req.renderJson(result);
    }

    public void settingsAction(WebRequest req) throws StreamWriteException, DatabindException, IOException, SQLException, AuthorizationException {
        if (!this.userService.isAdmin(req.getUserId())) {
            throw new AuthorizationException("Only admin allowed");
        }
        CacheUtil.removeCache("licenseResponse");
        LicenseHandler lh = new LicenseHandler(this.userService.getConnection());
        lh.checkLicense(this.appConfig, this.appConfig.getLicenseCode());
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("success", true);
        result.put("appLicenseCode", this.appConfig.getLicenseCode());
        result.put("licenseMessage", lh.getMessage());
        result.put("licenseValidLicense", lh.validLicense());
        req.renderJson(result);
    }

    public void checkLicenseCodeAction(WebRequest req) throws AuthorizationException, SQLException, StreamWriteException, DatabindException, IOException {
        if (!this.userService.isAdmin(req.getUserId())) {
            throw new AuthorizationException("Only admin allowed");
        }
        CacheUtil.removeCache("licenseResponse");
        LicenseHandler lh = new LicenseHandler(this.userService.getConnection());
        lh.checkLicense(this.appConfig, req.getParameter("code"));
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("success", true);
        result.put("appLicenseCode", this.appConfig.getLicenseCode());
        result.put("userMessage", lh.getUserMessage());
        result.put("licenseMessage", lh.getMessage());
        result.put("licenseValidLicense", lh.validLicense());
        req.renderJson(result);
    }
}

